<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Usuario.php';
$model = new Usuario($pdo);
$usuario = $model->find((int)($_GET['id'] ?? 0));
if (!$usuario) {
    header('Location: index.php?page=usuarios');
    exit;
}
$rol = $pdo->prepare('SELECT nombre FROM roles WHERE id = ?');
$rol->execute([$usuario['rol_id']]);
$rolNombre = $rol->fetchColumn();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Usuario #<?php echo $usuario['id']; ?></h1>
        <div class="card">
            <div class="card-body">
                <p><strong>Nombre:</strong> <?php echo htmlspecialchars($usuario['nombre']); ?></p>
                <p><strong>Usuario:</strong> <?php echo $usuario['usuario']; ?></p>
                <p><strong>Rol:</strong> <?php echo $rolNombre; ?></p>
                <p><strong>Activo:</strong> <?php echo $usuario['activo'] ? 'Sí' : 'No'; ?></p>
                <a href="index.php?page=usuarios" class="btn btn-secondary">Volver</a>
            </div>
        </div>
    </div>
</section>
