<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Usuario.php';
$model = new Usuario($pdo);
$usuario = $model->find((int)($_GET['id'] ?? 0));
if (!$usuario) {
    header('Location: index.php?page=usuarios');
    exit;
}
$roles = $pdo->query('SELECT id, nombre FROM roles')->fetchAll(PDO::FETCH_ASSOC);
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Editar Usuario</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/usuarios.php">
                    <input type="hidden" name="id" value="<?php echo $usuario['id']; ?>">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" value="<?php echo htmlspecialchars($usuario['nombre']); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Usuario</label>
                        <input type="text" name="usuario" class="form-control" value="<?php echo $usuario['usuario']; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Clave</label>
                        <input type="password" name="clave" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Rol</label>
                        <select name="rol_id" class="form-control">
                            <?php foreach ($roles as $r): ?>
                                <option value="<?php echo $r['id']; ?>" <?php echo $usuario['rol_id'] == $r['id'] ? 'selected' : ''; ?>><?php echo $r['nombre']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group form-check">
                        <input type="checkbox" class="form-check-input" name="activo" value="1" <?php echo $usuario['activo'] ? 'checked' : ''; ?>>
                        <label class="form-check-label">Activo</label>
                    </div>
                    <button class="btn btn-primary" type="submit">Actualizar</button>
                    <a href="index.php?page=usuarios" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
