<?php
require_once __DIR__ . '/../../includes/db.php';
$roles = $pdo->query('SELECT id, nombre FROM roles')->fetchAll(PDO::FETCH_ASSOC);
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Nuevo Usuario</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/usuarios.php">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Usuario</label>
                        <input type="text" name="usuario" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Clave</label>
                        <input type="password" name="clave" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Rol</label>
                        <select name="rol_id" class="form-control">
                            <?php foreach ($roles as $r): ?>
                                <option value="<?php echo $r['id']; ?>"><?php echo $r['nombre']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group form-check">
                        <input type="checkbox" class="form-check-input" name="activo" value="1" checked>
                        <label class="form-check-label">Activo</label>
                    </div>
                    <button class="btn btn-primary" type="submit">Guardar</button>
                    <a href="index.php?page=usuarios" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
