<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Orden.php';
require_once __DIR__ . '/../../models/DetalleOrden.php';
require_once __DIR__ . '/../../models/Producto.php';
require_once __DIR__ . '/../../models/Categoria.php';
require_once __DIR__ . '/../../models/MetodoPago.php';

$ordenModel = new Orden($pdo);
$detalleModel = new DetalleOrden($pdo);
$productoModel = new Producto($pdo);
$categoriaModel = new Categoria($pdo);
$metodoPagoModel = new MetodoPago($pdo);

$orden = $ordenModel->find((int)($_GET['id'] ?? 0));
if (!$orden) {
    header('Location: index.php?page=orden');
    exit;
}
$detalles = $detalleModel->forOrden($orden['id']);
$categorias = $categoriaModel->all();
$currentCat = (int)($_GET['cat'] ?? 0);
$productos = $currentCat ? $productoModel->byCategoria($currentCat) : [];
$metodosPago = $metodoPagoModel->all();
?>
<style>
.category-box, .product-box {
    cursor: pointer;
}
.category-box img {
    width: 40px;
    height: 40px;
    object-fit: cover;
}
.product-box img {
    width: 100%;
    height: 100px;
    object-fit: cover;
}
</style>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Orden #<?php echo $orden['id']; ?> <small class="text-muted">(<?php echo $orden['estado']; ?>)</small></h1>
        <div class="row">
            <div class="col-12 col-md-7">
                <div class="row mb-3">
                    <?php foreach ($categorias as $c): ?>
                    <div class="col-3 col-md-2 mb-3">
                        <a href="index.php?page=orden/edit&id=<?php echo $orden['id']; ?>&cat=<?php echo $c['id']; ?>" class="card text-center category-box <?php echo $currentCat == $c['id'] ? 'border-primary' : ''; ?>">
                            <div class="card-body p-2">
                                <?php $iconPath = $c['icono'] ? __DIR__ . '/../../' . $c['icono'] : null; ?>
                                <?php if ($c['icono'] && $iconPath && is_file($iconPath)): ?>
                                    <img src="<?php echo $c['icono']; ?>" alt="" class="mb-1">
                                <?php elseif ($c['icono']): ?>
                                    <span class="mb-1" style="font-size:32px;display:block;line-height:1;"><?php echo htmlspecialchars($c['icono']); ?></span>
                                <?php else: ?>
                                    <img src="assets/img/placeholder.svg" alt="" class="mb-1">
                                <?php endif; ?>
                                <div class="small mt-1"><?php echo htmlspecialchars($c['nombre']); ?></div>
                            </div>
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if ($currentCat): ?>
                <div class="row mb-4">
                    <?php foreach ($productos as $p): ?>
                    <div class="col-6 col-md-3 mb-3">
                        <form method="POST" action="controllers/orden.php?action=addItem" class="card product-box">
                            <input type="hidden" name="orden_id" value="<?php echo $orden['id']; ?>">
                            <input type="hidden" name="producto_id" value="<?php echo $p['id']; ?>">
                            <input type="hidden" name="cantidad" value="1">
                            <button type="submit" class="btn p-0 border-0" style="background:none;width:100%;">
                                <img src="<?php echo $p['imagen'] ?: 'assets/img/placeholder.svg'; ?>" alt="<?php echo htmlspecialchars($p['nombre']); ?>">
                                <div class="p-2 text-center small"><?php echo htmlspecialchars($p['nombre']); ?></div>
                            </button>
                        </form>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            <div class="col-12 col-md-5">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>Imagen</th>
                            <th>Producto</th>
                            <th>Cantidad</th>
                            <th>Precio</th>
                            <th>Total</th>
                            <th>Estado</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $hasPendiente=false; $hasServido=false; $total=0; foreach ($detalles as $d): ?>
                        <?php
                            $rowClass = '';
                            if ($d['estado'] === 'terminado') $rowClass = 'table-success';
                            if ($d['estado'] === 'servido') { $rowClass = 'table-secondary'; $hasServido=true; }
                            if ($d['estado'] === 'pendiente') $hasPendiente = true;
                            $total += $d['precio_unitario'] * $d['cantidad'];
                        ?>
                        <tr class="<?php echo $rowClass; ?>">
                            <td><img src="<?php echo $d['imagen'] ?: 'assets/img/placeholder.svg'; ?>" alt="" style="width:40px;height:40px;object-fit:cover;"></td>
                            <td><?php echo htmlspecialchars($d['nombre']); ?></td>
                            <td>
                                <form method="POST" action="controllers/orden.php?action=updateItem" class="form-inline">
                                    <input type="hidden" name="id" value="<?php echo $d['id']; ?>">
                                    <input type="hidden" name="orden_id" value="<?php echo $orden['id']; ?>">
                                    <input type="number" name="cantidad" value="<?php echo $d['cantidad']; ?>" class="form-control form-control-sm" min="1" style="width:70px;">
                                    <button class="btn btn-sm btn-secondary ml-1" type="submit">Ok</button>
                                </form>
                            </td>
                            <td><?php echo $d['precio_unitario']; ?></td>
                            <td><?php echo $d['precio_unitario'] * $d['cantidad']; ?></td>
                            <td><?php echo $d['estado']; ?></td>
                            <td>
                                <?php if ($d['estado'] === 'terminado'): ?>
                                    <form method="POST" action="controllers/orden.php?action=updateItemStatus" class="d-inline">
                                        <input type="hidden" name="id" value="<?php echo $d['id']; ?>">
                                        <input type="hidden" name="orden_id" value="<?php echo $orden['id']; ?>">
                                        <input type="hidden" name="estado" value="servido">
                                        <input type="hidden" name="from" value="orden">
                                        <button class="btn btn-sm btn-info" title="Servido"><i class="fas fa-bell"></i></button>
                                    </form>
                                <?php endif; ?>
                                <a class="btn btn-sm btn-danger" href="controllers/orden.php?action=deleteItem&id=<?php echo $d['id']; ?>&orden_id=<?php echo $orden['id']; ?>">X</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php if ($hasPendiente): ?>
                    <a class="btn btn-warning" href="controllers/orden.php?action=send&id=<?php echo $orden['id']; ?>">Enviar a cocina</a>
                <?php endif; ?>
                <?php if ($hasServido): ?>
                    <button class="btn btn-primary" data-toggle="modal" data-target="#cobrarModal">Cobrar Orden</button>
                <?php endif; ?>
                <a href="index.php?page=orden" class="btn btn-secondary">Regresar</a>

                <div class="modal fade" id="cobrarModal" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <form method="POST" action="controllers/orden.php?action=finish" class="modal-content">
                            <input type="hidden" name="id" value="<?php echo $orden['id']; ?>">
                            <div class="modal-header">
                                <h5 class="modal-title">Cobrar Orden #<?php echo $orden['id']; ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>Método de Pago</label>
                                    <select name="metodo_pago_id" id="metodoPago" class="form-control">
                                        <?php foreach ($metodosPago as $mp): ?>
                                        <option value="<?php echo $mp['id']; ?>"><?php echo htmlspecialchars($mp['metodo']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group" id="pagoEfectivo" style="display:none;">
                                    <label>Cantidad pagada</label>
                                    <input type="number" step="0.01" min="0" class="form-control" id="pagoInput">
                                </div>
                                <div class="form-group" id="cambioDiv" style="display:none;">
                                    <label>Cambio</label>
                                    <input type="text" class="form-control" id="cambioInput" readonly>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-primary">Cobrar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
document.getElementById('metodoPago').addEventListener('change', function() {
    const efectivo = this.options[this.selectedIndex].text.toLowerCase().includes('efectivo');
    document.getElementById('pagoEfectivo').style.display = efectivo ? 'block' : 'none';
    document.getElementById('cambioDiv').style.display = efectivo ? 'block' : 'none';
});
const pagoInput = document.getElementById('pagoInput');
if (pagoInput) {
    pagoInput.addEventListener('input', function() {
        const total = <?php echo $total; ?>;
        const cambio = parseFloat(this.value || 0) - total;
        document.getElementById('cambioInput').value = cambio.toFixed(2);
    });
}
</script>
