<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Insumo.php';
$model = new Insumo($pdo);
$insumo = $model->find((int)($_GET['id'] ?? 0));
if (!$insumo) {
    header('Location: index.php?page=insumos');
    exit;
}
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Insumo #<?php echo $insumo['id']; ?></h1>
        <div class="card">
            <div class="card-body">
                <p><strong>Nombre:</strong> <?php echo htmlspecialchars($insumo['nombre']); ?></p>
                <p><strong>Unidad de medida:</strong> <?php echo $insumo['unidad_medida']; ?></p>
                <p><strong>Precio unitario:</strong> <?php echo $insumo['precio_unitario']; ?></p>
                <p><strong>Stock:</strong> <?php echo $insumo['stock']; ?></p>
                <a href="index.php?page=insumos" class="btn btn-secondary">Volver</a>
            </div>
        </div>
    </div>
</section>
