<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Insumo.php';
$model = new Insumo($pdo);
$insumos = $model->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Insumos</h1>
        <a href="index.php?page=insumos/create" class="btn btn-primary mb-3">Nuevo Insumo</a>
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nombre</th>
                            <th>Stock</th>
                            <th>Unidad</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($insumos as $i): ?>
                        <tr>
                            <td><?php echo $i['id']; ?></td>
                            <td><?php echo htmlspecialchars($i['nombre']); ?></td>
                            <td><?php echo $i['stock']; ?></td>
                            <td><?php echo $i['unidad_medida']; ?></td>
                            <td>
                                <a href="index.php?page=insumos/view&id=<?php echo $i['id']; ?>" class="btn btn-sm btn-secondary">Ver</a>
                                <a href="index.php?page=insumos/edit&id=<?php echo $i['id']; ?>" class="btn btn-sm btn-info">Editar</a>
                                <a href="controllers/insumos.php?delete=<?php echo $i['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">Eliminar</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
