<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Insumo.php';
$model = new Insumo($pdo);
$insumo = $model->find((int)($_GET['id'] ?? 0));
if (!$insumo) {
    header('Location: index.php?page=insumos');
    exit;
}
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Editar Insumo</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/insumos.php">
                    <input type="hidden" name="id" value="<?php echo $insumo['id']; ?>">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" value="<?php echo htmlspecialchars($insumo['nombre']); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Unidad de medida</label>
                        <input type="text" name="unidad_medida" class="form-control" value="<?php echo $insumo['unidad_medida']; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Precio unitario</label>
                        <input type="number" step="0.01" name="precio_unitario" class="form-control" value="<?php echo $insumo['precio_unitario']; ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Stock</label>
                        <input type="number" step="0.01" name="stock" class="form-control" value="<?php echo $insumo['stock']; ?>" required>
                    </div>
                    <button class="btn btn-primary" type="submit">Actualizar</button>
                    <a href="index.php?page=insumos" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
