<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../models/Orden.php';
require_once __DIR__ . '/../models/DetalleOrden.php';

$ordenModel = new Orden($pdo);
$detalleModel = new DetalleOrden($pdo);
$ordenes = $ordenModel->getEnPreparacion();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Cocina</h1>
        <div class="row">
            <?php foreach ($ordenes as $o): ?>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        Orden #<?php echo $o['id']; ?> - Mesa <?php echo $o['mesa']; ?>
                        <span class="badge badge-info float-right"><?php echo $o['estado']; ?></span>
                    </div>
                    <div class="card-body">
                        <ul class="mb-3 list-unstyled">
                            <?php foreach ($detalleModel->forOrden($o['id']) as $d): ?>
                            <li class="mb-2">
                                <?php $lock = in_array($d['estado'], ['servido','terminado']); ?>
                                <form method="POST" action="controllers/orden.php?action=updateItemStatus" class="form-inline">
                                    <input type="hidden" name="id" value="<?php echo $d['id']; ?>">
                                    <input type="hidden" name="orden_id" value="<?php echo $o['id']; ?>">
                                    <input type="hidden" name="from" value="cocina">
                                    <?php if ($lock): ?>
                                        <span class="badge badge-secondary mr-2"><?php echo $d['estado']; ?></span>
                                    <?php else: ?>
                                        <select name="estado" class="form-control form-control-sm mr-1">
                                            <?php $estados = ['pendiente en cocina','en preparacion','terminado','servido']; foreach ($estados as $e): ?>
                                                <option value="<?php echo $e; ?>" <?php echo $d['estado'] === $e ? 'selected' : ''; ?>><?php echo $e; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <button class="btn btn-primary btn-sm mr-2" type="submit">Ok</button>
                                    <?php endif; ?>
                                    <span><?php echo $d['cantidad'] . 'x ' . htmlspecialchars($d['nombre']); ?></span>
                                </form>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                        <a href="controllers/orden.php?action=send&id=<?php echo $o['id']; ?>&from=cocina" class="btn btn-warning btn-sm mr-1">En preparacion</a>
                        <a href="controllers/orden.php?action=ready&id=<?php echo $o['id']; ?>" class="btn btn-success btn-sm">Terminado</a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
