<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Categoria.php';
$model = new Categoria($pdo);
$categorias = $model->all();
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Categor&iacute;as</h1>
        <a href="index.php?page=categorias/create" class="btn btn-primary mb-3">Nueva Categor&iacute;a</a>
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Icono</th>
                            <th>Nombre</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($categorias as $c): ?>
                        <tr>
                            <td><?php echo $c['id']; ?></td>
                            <td>
                                <?php $iconPath = $c['icono'] ? __DIR__ . '/../../' . $c['icono'] : null; ?>
                                <?php if ($c['icono'] && $iconPath && is_file($iconPath)): ?>
                                    <img src="<?php echo $c['icono']; ?>" alt="" style="width:40px;height:40px;object-fit:cover;">
                                <?php elseif ($c['icono']): ?>
                                    <span style="font-size:32px;"><?php echo htmlspecialchars($c['icono']); ?></span>
                                <?php else: ?>
                                    <img src="assets/img/placeholder.svg" alt="" style="width:40px;height:40px;object-fit:cover;">
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($c['nombre']); ?></td>
                            <td>
                                <a href="index.php?page=categorias/view&id=<?php echo $c['id']; ?>" class="btn btn-sm btn-secondary">Ver</a>
                                <a href="index.php?page=categorias/edit&id=<?php echo $c['id']; ?>" class="btn btn-sm btn-info">Editar</a>
                                <a href="controllers/categorias.php?delete=<?php echo $c['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">Eliminar</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
