<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../models/Categoria.php';
$model = new Categoria($pdo);
$categoria = $model->find((int)($_GET['id'] ?? 0));
$dir = __DIR__ . '/../../uploads/iconos';
$existingIcons = is_dir($dir) ? array_values(array_diff(scandir($dir), ['.', '..'])) : [];
if (!$categoria) {
    header('Location: index.php?page=categorias');
    exit;
}
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Editar Categor&iacute;a</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/categorias.php" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?php echo $categoria['id']; ?>">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" value="<?php echo htmlspecialchars($categoria['nombre']); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Descripci&oacute;n</label>
                        <input type="text" name="descripcion" class="form-control" value="<?php echo $categoria['descripcion']; ?>">
                    </div>
                    <?php if ($categoria['icono']): ?>
                    <div class="form-group">
                        <label>Icono actual</label><br>
                        <?php $iconPath = __DIR__ . '/../../' . $categoria['icono']; ?>
                        <?php if (is_file($iconPath)): ?>
                            <img src="<?php echo $categoria['icono']; ?>" alt="Icono" style="max-width:150px;">
                        <?php else: ?>
                            <span style="font-size:60px;"><?php echo htmlspecialchars($categoria['icono']); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label>Subir nuevo icono (opcional)</label>
                        <input type="file" name="icono" class="form-control-file">
                    </div>
                    <?php if ($existingIcons): ?>
                    <div class="form-group">
                        <label>O seleccionar existente</label>
                        <select name="icono_existente" class="form-control">
                            <option value="">-- Ninguno --</option>
                            <?php foreach ($existingIcons as $ic): ?>
                            <option value="<?php echo 'uploads/iconos/' . $ic; ?>" <?php echo $categoria['icono'] === 'uploads/iconos/' . $ic ? 'selected' : ''; ?>><?php echo $ic; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <button class="btn btn-primary" type="submit">Actualizar</button>
                    <a href="index.php?page=categorias" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
