<?php
require_once __DIR__ . '/../../includes/db.php';
$dir = __DIR__ . '/../../uploads/iconos';
$existingIcons = is_dir($dir) ? array_values(array_diff(scandir($dir), ['.', '..'])) : [];
?>
<section class="content pt-3">
    <div class="container-fluid">
        <h1>Nueva Categor&iacute;a</h1>
        <div class="card">
            <div class="card-body">
                <form method="POST" action="controllers/categorias.php" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Descripci&oacute;n</label>
                        <input type="text" name="descripcion" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Icono (opcional)</label>
                        <input type="file" name="icono" class="form-control-file">
                    </div>
                    <?php if ($existingIcons): ?>
                    <div class="form-group">
                        <label>O seleccionar existente</label>
                        <select name="icono_existente" class="form-control">
                            <option value="">-- Ninguno --</option>
                            <?php foreach ($existingIcons as $ic): ?>
                            <option value="<?php echo 'uploads/iconos/' . $ic; ?>"><?php echo $ic; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <button class="btn btn-primary" type="submit">Guardar</button>
                    <a href="index.php?page=categorias" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</section>
