<?php
require_once 'Model.php';
class MovimientoCaja extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'caja_movimientos', ['caja_id','tipo','monto','descripcion','fecha']);
    }

    public function forCaja(int $cajaId): array {
        $stmt = $this->pdo->prepare("SELECT * FROM caja_movimientos WHERE caja_id = ? ORDER BY fecha");
        parent::__construct($pdo, 'movimientos_caja', ['caja_id','tipo','monto','descripcion','fecha','usuario_id']);
    }

    public function create(array $data): void {
        if (!isset($data['fecha'])) {
            $data['fecha'] = date('Y-m-d H:i:s');
        }
        parent::create($data);
    }

    public function forCaja(int $cajaId): array {
        $stmt = $this->pdo->prepare("SELECT * FROM movimientos_caja WHERE caja_id = ? ORDER BY fecha DESC");
        $stmt->execute([$cajaId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
