<?php
class Model {
    protected PDO $pdo;
    protected string $table;
    protected array $fields;

    public function __construct(PDO $pdo, string $table, array $fields) {
        $this->pdo = $pdo;
        $this->table = $table;
        $this->fields = $fields;
    }

    public function all(): array {
        return $this->pdo->query("SELECT * FROM {$this->table}")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function find(int $id): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM {$this->table} WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
    }

    public function create(array $data): void {
        $cols = implode(',', $this->fields);
        $placeholders = implode(',', array_fill(0, count($this->fields), '?'));
        $stmt = $this->pdo->prepare("INSERT INTO {$this->table} ($cols) VALUES ($placeholders)");
        $stmt->execute(array_values($data));
    }

    public function update(int $id, array $data): void {
        $set = implode('=?, ', $this->fields).'=?';
        $stmt = $this->pdo->prepare("UPDATE {$this->table} SET $set WHERE id = ?");
        $values = array_values($data);
        $values[] = $id;
        $stmt->execute($values);
    }

    public function delete(int $id): void {
        $stmt = $this->pdo->prepare("DELETE FROM {$this->table} WHERE id = ?");
        $stmt->execute([$id]);
    }
}
