<?php
require_once 'Model.php';
class DetalleOrden extends Model {
    public function __construct(PDO $pdo) {
        parent::__construct($pdo, 'detalle_orden', ['orden_id','producto_id','cantidad','precio_unitario','estado']);
    }

    public function forOrden(int $ordenId): array {
        $stmt = $this->pdo->prepare("SELECT d.*, p.nombre, p.imagen FROM detalle_orden d JOIN productos p ON d.producto_id=p.id WHERE d.orden_id = ?");
        $stmt->execute([$ordenId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
