<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../models/Producto.php';
$model = new Producto($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'nombre' => $_POST['nombre'],
        'descripcion' => $_POST['descripcion'],
        'precio' => $_POST['precio'],
        'categoria_id' => $_POST['categoria_id'] ?? null,
        'imagen' => null
    ];

    // Path to store product images
    $uploadDir = __DIR__ . '/../uploads/productos/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Check if user selected an existing image from repository
    if (!empty($_POST['imagen_existente'])) {
        $data['imagen'] = $_POST['imagen_existente'];
    }

    // Handle new image upload
    if (!empty($_FILES['imagen']['name'])) {
        $filename = uniqid() . '-' . preg_replace('/[^a-zA-Z0-9.\-_]/', '_', $_FILES['imagen']['name']);
        $target = $uploadDir . $filename;
        if (move_uploaded_file($_FILES['imagen']['tmp_name'], $target)) {
            $data['imagen'] = 'uploads/productos/' . $filename;
        }
    }

    if (!empty($_POST['id'])) {
        $model->update((int)$_POST['id'], $data);
    } else {
        $model->create($data);
    }
    header('Location: ../index.php?page=productos');
    exit;
}

if (isset($_GET['delete'])) {
    $model->delete((int)$_GET['delete']);
    header('Location: ../index.php?page=productos');
    exit;
}
