<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../models/Orden.php';
require_once __DIR__ . '/../models/DetalleOrden.php';
require_once __DIR__ . '/../models/Mesa.php';
require_once __DIR__ . '/../models/Producto.php';

$ordenModel = new Orden($pdo);
$detalleModel = new DetalleOrden($pdo);
$mesaModel = new Mesa($pdo);
$productoModel = new Producto($pdo);
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'new':
        $mesaId = (int)($_GET['mesa_id'] ?? 0);
        if ($mesaId) {
            $ordenModel->create([
                'mesa_id' => $mesaId,
                'usuario_id' => $_SESSION['user_id'],
                'estado' => 'pendiente'
            ]);
            $ordenId = $pdo->lastInsertId();
            $mesa = $mesaModel->find($mesaId);
            $mesaModel->update($mesaId, ['numero' => $mesa['numero'], 'estado' => 'ocupada']);
            header('Location: ../index.php?page=orden/edit&id=' . $ordenId);
            exit;
        }
        break;

    case 'addItem':
        $ordenId = (int)($_POST['orden_id'] ?? 0);
        $prodId = (int)($_POST['producto_id'] ?? 0);
        $cant = (int)($_POST['cantidad'] ?? 1);
        if ($ordenId && $prodId && $cant > 0) {
            $prod = $productoModel->find($prodId);
            $detalleModel->create([
                'orden_id' => $ordenId,
                'producto_id' => $prodId,
                'cantidad' => $cant,
                'precio_unitario' => $prod['precio'],
                'estado' => 'pendiente'
            ]);
        }
        header('Location: ../index.php?page=orden/edit&id=' . $ordenId);
        exit;

    case 'updateItem':
        $id = (int)($_POST['id'] ?? 0);
        $ordenId = (int)($_POST['orden_id'] ?? 0);
        $cant = (int)($_POST['cantidad'] ?? 1);
        if ($id && $cant > 0) {
            $item = $detalleModel->find($id);
            $detalleModel->update($id, [
                'orden_id' => $item['orden_id'],
                'producto_id' => $item['producto_id'],
                'cantidad' => $cant,
                'precio_unitario' => $item['precio_unitario'],
                'estado' => $item['estado']
            ]);
        }
        header('Location: ../index.php?page=orden/edit&id=' . $ordenId);
        exit;

    case 'updateItemStatus':
        $id = (int)($_POST['id'] ?? 0);
        $ordenId = (int)($_POST['orden_id'] ?? 0);
        $estado = $_POST['estado'] ?? '';
        if ($id && $estado) {
            $item = $detalleModel->find($id);
            $detalleModel->update($id, [
                'orden_id' => $item['orden_id'],
                'producto_id' => $item['producto_id'],
                'cantidad' => $item['cantidad'],
                'precio_unitario' => $item['precio_unitario'],
                'estado' => $estado
            ]);
        }
        $from = $_POST['from'] ?? '';
        if ($from === 'orden') {
            header('Location: ../index.php?page=orden/edit&id=' . $ordenId);
        } else {
            header('Location: ../index.php?page=cocina');
        }
        exit;

    case 'deleteItem':
        $id = (int)($_GET['id'] ?? 0);
        $ordenId = (int)($_GET['orden_id'] ?? 0);
        if ($id) {
            $detalleModel->delete($id);
        }
        header('Location: ../index.php?page=orden/edit&id=' . $ordenId);
        exit;

    case 'send':
        $id = (int)($_GET['id'] ?? 0);
        $from = $_GET['from'] ?? '';
        if ($id) {
            $orden = $ordenModel->find($id);
            $estado = $from === 'cocina' ? 'en preparacion' : 'pendiente en cocina';
            $ordenModel->update($id, [
                'mesa_id' => $orden['mesa_id'],
                'usuario_id' => $orden['usuario_id'],
                'estado' => $estado
            ]);
            if ($estado === 'pendiente en cocina') {
                $stmt = $pdo->prepare("UPDATE detalle_orden SET estado='pendiente en cocina' WHERE orden_id=? AND estado='pendiente'");
                $stmt->execute([$id]);
            }
        }
        if ($from === 'cocina') {
            header('Location: ../index.php?page=cocina');
        } else {
            header('Location: ../index.php?page=orden/edit&id=' . $id);
        }
        exit;

    case 'ready':
        $id = (int)($_GET['id'] ?? 0);
        if ($id) {
            $orden = $ordenModel->find($id);
            $ordenModel->update($id, [
                'mesa_id' => $orden['mesa_id'],
                'usuario_id' => $orden['usuario_id'],
                // once terminada en cocina vuelve a estado pendiente para ser servida
                'estado' => 'pendiente'
            ]);
            $pdo->prepare("UPDATE detalle_orden SET estado='terminado' WHERE orden_id=? AND estado<>'servido'")->execute([$id]);
        }
        header('Location: ../index.php?page=cocina');
        exit;

    case 'serve':
        $id = (int)($_GET['id'] ?? 0);
        if ($id) {
            $orden = $ordenModel->find($id);
            $ordenModel->update($id, [
                'mesa_id' => $orden['mesa_id'],
                'usuario_id' => $orden['usuario_id'],
                'estado' => 'servido'
            ]);
            $pdo->prepare("UPDATE detalle_orden SET estado='servido' WHERE orden_id=?")->execute([$id]);
        }
        header('Location: ../index.php?page=cocina');
        exit;

    case 'finish':
        $id = (int)($_POST['id'] ?? ($_GET['id'] ?? 0));
        $metodoPagoId = isset($_POST['metodo_pago_id']) ? (int)$_POST['metodo_pago_id'] : null;
        if ($id) {
            $orden = $ordenModel->find($id);
            $mesa = $mesaModel->find($orden['mesa_id']);
            // calcular total
            $stmt = $pdo->prepare('SELECT SUM(cantidad*precio_unitario) AS total FROM detalle_orden WHERE orden_id = ?');
            $stmt->execute([$id]);
            $total = $stmt->fetchColumn() ?: 0;
            // crear venta
            $pdo->prepare('INSERT INTO ventas (usuario_id, mesa_id, total, metodo_pago_id) VALUES (?,?,?,?)')->execute([
                $_SESSION['user_id'],
                $orden['mesa_id'],
                $total,
                $metodoPagoId
            ]);
            $ventaId = $pdo->lastInsertId();
            // copiar detalles
            $det = $detalleModel->forOrden($id);
            $ins = $pdo->prepare('INSERT INTO detalle_venta (venta_id, producto_id, cantidad, precio_unitario) VALUES (?,?,?,?)');
            foreach ($det as $d) {
                $ins->execute([$ventaId, $d['producto_id'], $d['cantidad'], $d['precio_unitario']]);
            }
            // actualizar mesa y orden
            $mesaModel->update($mesa['id'], ['numero' => $mesa['numero'], 'estado' => 'disponible']);
            $ordenModel->update($id, [
                'mesa_id' => $orden['mesa_id'],
                'usuario_id' => $orden['usuario_id'],
                'estado' => 'finalizado'
            ]);
        }
        header('Location: ../index.php?page=orden');
        exit;
}
header('Location: ../index.php?page=orden');
