<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../models/Categoria.php';
$model = new Categoria($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $existing = null;
    if (!empty($_POST['id'])) {
        $existing = $model->find((int)$_POST['id']);
    }
    $data = [
        'nombre' => $_POST['nombre'],
        'descripcion' => $_POST['descripcion'],
        'icono' => $existing['icono'] ?? null
    ];

    $uploadDir = __DIR__ . '/../uploads/iconos/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    if (!empty($_POST['icono_existente'])) {
        $data['icono'] = $_POST['icono_existente'];
    }

    if (!empty($_FILES['icono']['name'])) {
        $filename = uniqid() . '-' . preg_replace('/[^a-zA-Z0-9.\-_]/', '_', $_FILES['icono']['name']);
        $target = $uploadDir . $filename;
        if (move_uploaded_file($_FILES['icono']['tmp_name'], $target)) {
            $data['icono'] = 'uploads/iconos/' . $filename;
        }
    }

    if (!empty($_POST['id'])) {
        $model->update((int)$_POST['id'], $data);
    } else {
        $model->create($data);
    }
    header('Location: ../index.php?page=categorias');
    exit;
}

if (isset($_GET['delete'])) {
    $model->delete((int)$_GET['delete']);
    header('Location: ../index.php?page=categorias');
    exit;
}
